#!/usr/bin/env python
# -*- coding: UTF8 -*-

"""
raspberryPiDemo.py

~~~~~~~~~~~~~~~~~~~~~~~~
This snippet is an example to show how to use our products with a raspberry pi.
You will need to install the pyserial library

To execute the code:
1. Open Terminal. 
2. Go to the directory in which the file is saved using the command cd 
(e.g. cd /home/pi/Documents/Demos/)
3. Launch the file with the command python
(e.g. python raspberryPiDemo.py)

For any other information, please refer to the document "RaspberryPi - UserGuide".
If you still can't find what you are looking for, don't hesitate to contact us at
info@amf.ch

"""

import sys
import serial
import time

# SPM initialisation
spm = serial.Serial('/dev/ttyUSB1',9600,timeout=1000)
print('SPM',spm.name)
spm.write(b"/1ZR\r") # initialise SPM

# RVM initialisation
rvm = serial.Serial('/dev/ttyUSB0',9600)
print('RVM',rvm.name)
rvm.write(b"/1ZR\r") # initialise RVM
time.sleep(30) #leave some time for both devices to finish initialising
print("Initialised")


# Example for a priming sequence
lsp.write(b"/1B2V600M1000A2000R\r")
# b"/1R\r" is the "standard code" for sending a command
# B2 - move to port 2 with the shortest path
# M1000 - wait 1000 milliseconds
# A2000 - go to absolute position 1000 (resolution 3000 by default. Use command N to change resolution)

time.sleep(9) # leave some time to execute command on top

lsp.write(b"/1B1V1000M1000A0R\r") # empty syringe through port 1
time.sleep(6)

sys.exit(0)