%--------------------------------------------------------------------------
% SPM_example.m
%--------------------------------------------------------------------------
% This program shows how to connect to the SPM (oem syringe pump)using
% matlab. The different commands can be found in the user manual.
%
% Advanced Microfluidics SA, August 2017
%--------------------------------------------------------------------------

% Configure serial port corresponding to LSPone
spm = serial('COM3','BaudRate',9600,'Parity','none','Databits',8,'Stopbits',1,'FlowControl','none','Terminator',{'CR','CR'},'Timeout',1000);

fopen(spm) % Open communication
fprintf(spm,'/1ZR') % Send command to device
pause(32) % Wait between commands. The pump needs some time to execute the command
fprintf(spm,'/1V300M1000O3M1000A2400M1000V80O5M200A0R')

% Read answer from device - useful to check that all is right
% See user manual - errors in case of problem
answer = fscanf(spm)

% Close communication
fclose(spm)
delete(spm)
clear spm