%--------------------------------------------------------------------------
% LSPOne_example.m
%--------------------------------------------------------------------------
% This program shows how to connect to the LSPone (laboratory syringe pump)
% using matlab. The different commands can be found in the user manual.
%
% Advanced Microfluidics SA, August 2017
%--------------------------------------------------------------------------

% Configure serial port corresponding to LSPone
lsp = serial('COM3','BaudRate',9600,'Parity','none','Databits',8,'Stopbits',1,'FlowControl','none','Terminator',{'CR','CR/LF'},'Timeout',1000);

fopen(lsp) % Open communication
%fprintf(lsp,'/1ZR') % Send command to device
%pause(32) % Wait between commands. The pump needs some time to execute the command
%fprintf(lsp,'/1V300M1000O3M1000A2400M1000V80O5M200A0R')
fprintf(lsp,'/1?6')

% Read answer from device - useful to check that all is right
% See user manual - errors in case of problem
answer = fscanf(lsp)

% Close communication
fclose(lsp)
delete(lsp)
clear lsp