﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO.Ports;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace LSPOne_example
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            /* Get ports name if available */
            String[] ports = SerialPort.GetPortNames();     
            if (ports.Count() < 1)
            {
                ConnectButton.Enabled = false;
                MessageBox.Show("No COM port found");
                return;
            }

            /* Add ports name to "SerialPortsComboBox" and select the first entry */
            SerialPortsComboBox.Items.AddRange(ports);
            SerialPortsComboBox.SelectedIndex = 0;
        }


        /* Connect to the serial COM port provided by "SerialPortsComboBox" on clicking event of ConnectButton */
        private void ConnectButton_Click(object sender, EventArgs e)
        {
            if (ConnectButton.Text == "Connect")
            {
                ConnectButton.Text = "Disconnect";
                SerialPortsComboBox.Enabled = false;
                String comport = SerialPortsComboBox.Text;
                SerialCOMPort.PortName = comport;
                SerialCOMPort.BaudRate = 9600;
                SerialCOMPort.NewLine = "\r\n";
                try
                {
                    SerialCOMPort.Open();
                }
                catch
                {
                    MessageBox.Show("Error while opening COM port");
                    ConnectButton.Enabled = true;
                    SerialPortsComboBox.Enabled = true;
                    return;
                }
            }
            else
            {                
                if (SerialCOMPort.IsOpen)
                    SerialCOMPort.Close();

                ConnectButton.Text = "Connect";
                SerialPortsComboBox.Enabled = true;
            }

        }
        
        /* Process a DataReceived event */
        private void SerialCOMPort_DataReceived(object sender, SerialDataReceivedEventArgs e)
        {
            String input = SerialCOMPort.ReadExisting();
            MethodInvoker action = delegate { ParseAnswer(input); };
            this.BeginInvoke(action);
        }

        /* Parse the data received and write it to the "StatusStrip" */
        public void ParseAnswer(String text)
        {
            StatusLabel.Text = "Received: " + text;
        }

        /* Send the command for Homing */
        private void HomingButton_Click(object sender, EventArgs e)
        {
            SerialCOMPort.Write("/1ZR" + "\r");
        }

        /* Go to port 2 with rotation clockwise */
        private void CWport2Button_Click(object sender, EventArgs e)
        {
            SerialCOMPort.Write("/1I2" + "R\r");
        }

        /* Go to port 4 with rotation counter-clockwise */
        private void CCWport4Button_Click(object sender, EventArgs e)
        {
            SerialCOMPort.Write("/1O4" + "R\r");
        }

        /* Send the custom commands found in "CustomCommandsTextbox" */
        private void SendCustomCommandsButton_Click(object sender, EventArgs e)
        {
            SerialCOMPort.Write(CustomCommandsTextbox.Text + "\r");
        }
    }
}
