#include <Wire.h>     // include Arduino Wire library

#define AMF_ADDRESS 0x64

void setup() {

  Wire.begin();
  Serial.begin(9600); // initialize serial communication 
  
  byte valve_status;
  byte valve_pos;
  
  Serial.println("Valve initialization");

  Wire.beginTransmission(AMF_ADDRESS);  // start I2C communication with the valve
  Wire.write(0x51);                     // valve command register
  Wire.write(0x10);                     // homing
  Wire.endTransmission(false);
  Wire.endTransmission();
  
  delay(5000);                          // wait until the valve is homed
  
  Wire.beginTransmission(AMF_ADDRESS);
  Wire.write(0x50); // valve status 
  Wire.endTransmission(false);
  Wire.requestFrom(AMF_ADDRESS, 1, false);
  valve_status = Wire.read();
  Wire.endTransmission();

  if (valve_status)                     //if the value is different than 0, an error occured
  {                    
    Serial.print("Valve error: ");
    Serial.println(valve_status);       // print the character
  }
  else
  {
    Serial.println("Valve homed");
    Serial.println("Valve move to port 2");
  
    Wire.beginTransmission(AMF_ADDRESS);
    Wire.write(0x51);                     // valve command
    Wire.write(0x22);                     // go to port 2
    Wire.endTransmission(false);
    Wire.endTransmission();
  
    delay(2000);
  
    Wire.beginTransmission(AMF_ADDRESS);
    Wire.write(0x52);                      // valve current port
    Wire.endTransmission(false);
    Wire.requestFrom(AMF_ADDRESS, 1, false);
    valve_pos = Wire.read();
    Wire.endTransmission();
  
    if(valve_pos == 2)
      Serial.println("Valve positioned on port 2");  
    else{
      Serial.print("Valve error, port = ");
      Serial.println(valve_pos);
    }
  }
}


void loop() {
 
}

 
